/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__stack.c,v 1.7 2006/01/25 18:38:00 bgoglin Exp $";

#include "mx__shim.h"
#include "mx__stack.h"

struct mx__ptr_stack
{
  int count;
  int max;
  void **p;
};

struct mx__ptr_stack *
mx__ptr_stack_alloc(int count)
{
  struct mx__ptr_stack *s;
  s = mx_malloc(sizeof (*s));
  if (s != NULL) {
    s->p = mx_malloc(count * sizeof(void*));
    s->count = 0;
    s->max = count;
    if (s->p == NULL) {
      mx_free(s);
      s = NULL;
    }
  }
  return s;
}

void
mx__ptr_stack_dealloc(struct mx__ptr_stack *s)
{
  mx_assert(s != NULL);
  mx_free(s->p);
  mx_free(s);
}

void
mx__ptr_stack_push(struct mx__ptr_stack *s, void* p)
{
  mx_assert(s->count < s->max);
  s->p[s->count++] = p;
}

void *
mx__ptr_stack_pop(struct mx__ptr_stack *s)
{
  if (s->count > 0) {
    return s->p[--s->count];
  }
  else {
    return NULL;
  }
}
